# Button Bar Widget

## Introduction

The button bar widget displays a horizontal row of clickable buttons,
each with a vector icon and a label.

A common use case for a button bar is to provide a set of actions that
are quick to access from the main screen of an app.

## Creating and configuring a button bar

Each button in a button bar has four main properties:

- its name, used to identify it to script
- a label that can be displayed to the user
- a named icon displayed when the button is inactive
- a named icon displayed when the button is highlighted (while it is
  being pressed)

You can set these properties, and add and remove buttons, using the 'Basic'
pane of the Property Inspector.

The appearance of the button bar is also configurable.  On the 'Basic'
pane, you can optionally make the background of the widget
transparent, or prevent the widget from being drawn with a border.
There is also a setting to change the style of the button bar: the
buttons can be displayed with labels, icons, or both.

On the 'Colors' pane of the Property Inspector, you can configure the
colors used to draw each part of the button bar.  The 'Item color' and
'Clicked item color' apply to both the label text and the icon.

The 'Font' pane provides settings for the font face and size used to
draw the labels on the buttons.

All of these properties are also accessible via script; visit the API
dictionary for the button bar widget for detailed information.

## Hooking up the button bar to a script

When one of the buttons is clicked, a **buttonClicked** message is
sent to the button bar's script.  It is sent through the normal
message path, so it can be handled in a behavior or in a group, card
or stack script in the normal way.

The **buttonClicked** handler is passed one argument -- the name of
the button that was clicked.

A quick way to handle the **buttonClicked** message is to use a
`switch` statement over the possible button names.  For example, this
could be the script of a button bar that has "Quit" and "Help"
buttons:

    on buttonClicked pButtonName
       switch pButtonName
          case "quit"
             doQuit
             break
          case "help"
             showHelpStack
             break
          default
             -- Unrecognized button name, do nothing
    end buttonClicked

Another possibility is to set the name of each button to the name of a
handler in your stack.  Think of the previous example of a button bar
which has "Quit" and "Help" buttons.  If you set the names to
`doQuitAction` and `doHelpAction`, respectively, then you could just
use the `send` command to turn the button click directly into a
message to the stack:

    on buttonClicked pButtonName
       send pButtonName to this stack
    end buttonClicked

This last approach is great if you would like to add and remove
buttons without needing to make many script changes.

## Getting help

The Button Bar widget has been developed by .com Solutions Inc., and is used by FmPro Migrator when performing conversions into LiveCode projects.

Support is available via the FmPro Migrator website:
http://www.fmpromigrator.com

<!--- Bug report / support instructions --->
