<?php
class UsersController extends AppController
{
    var $components = array('Auth', 'Email');

    /**
     * Runs automatically before each controller action is called
     */
    function beforeFilter()
    {
        $this->Auth->allow('register', 'recover', 'verify');
        parent::beforeFilter();
        $this->Auth->autoRedirect = false;
        $this->Auth->loginError = 'Login failure due to: incorrect username/password, or inactive account status.';
        $this->Auth->authError = 'Your user account role (' . $this->Auth->user('role') . ') does not have access to this feature (' . $this->action .').';
        $this->Auth->loginRedirect = '/default';
        $this->Auth->logoutRedirect = '/default';
        $this->Auth->userScope = array('User.inactive' => false);
        $this->Auth->allow('add');
    }

    /**
     * Registration page for new users
     */
    function add()
    {
        if (!empty($this->data)) {
            $this->User->create();
            if ($this->User->save($this->data)) {
            	if ($this->User->find('count')<2) {
        			// If first user account - then create with [Full Access] role.
        			$this->User->saveField('role', '[Full Access]');
        		}  
        		// Always set Inactive => 0
                $this->User->saveField('inactive', '0');
                $this->Session->setFlash('Your account has been created','flash_info');
                $this->redirect('/default');
            } else {
                $this->Session->setFlash('Your account could not be created. Please, try again.', 'flash_error');
            }
        }
    }

    /**
     * Run directly after the Auth component has executed
     */
    function login()
    {
        // Check for a successful login
        if (!empty($this->data) && $id = $this->Auth->user('id')) {
            // Set the lastlogin time
            $this->User->id = $id;
            $this->User->saveField('lastlogin', date('Y-m-d H:i:s'));

            // Redirect the user
            $url = array('controller' => 'users', 'action' => 'account');
            if ($this->Session->check('Auth.redirect')) {
                $url = $this->Session->read('Auth.redirect');
            }
            $this->redirect($url);
        }
    }


    /**
     * Log a user out
     */
    function logout()
    {
       return $this->redirect($this->Auth->logout());
    }
    
    /**
     * Account details page (change password)
     */

    function account()
    {
        $this->User->useValidationRules('ChangePassword');
        $this->User->validate['password_confirm']['compare']['rule'] =
          array('password_match', 'password', false);
        $this->User->set($this->data);
        if (!empty($this->data) && $this->User->validates()) {
            $this->Session->setFlash('Your password has been updated','flash_info');
            $this->User->id = $this->Auth->user('id');
            $this->User->saveField('password',
            $this->Auth->password($this->data['User']['password']));
            $this->redirect(array('action' => 'login'));
        }
        $current_user = $this->User->findById($this->Auth->user('id'));
        $this->set('current_user', $current_user);
    }

    /**
     * Allows the user to email themselves a password redemption token
     */
    function recover()
    {
        if ($this->Auth->user()) {
            $this->redirect(array('controller' => 'users', 'action' => 'account'));
        }

        if (!empty($this->data['User']['email'])) {
            $Token = ClassRegistry::init('Token');
            $user = $this->User->findByEmail($this->data['User']['email']);

            if ($user === false) {
                $this->Session->setFlash('No matching user found','flash_info');
                return false;
            }

            $token = $Token->generate(array('User' => $user['User']));
            $this->Session->setFlash('An email has been sent to your account, please follow the instructions in this email.','flash_info');
            $this->Email->to = $user['User']['email'];
            $this->Email->subject = 'Password Recovery';
            $this->Email->from = 'Support <support@example.com>';
            $this->Email->template = 'recover';
            $this->set('user', $user);
            $this->set('token', $token);
            $this->Email->send();
        }
    }

    /**
     * Accepts a valid token and resets the users password
     */
    function verify($token = null)
    {
        if ($this->Auth->user()) {
            $this->redirect(array('controller' => 'users', 'action' => 'account'));
        }

        $Token = ClassRegistry::init('Token');
        if ($data = $Token->get($token)) {
            // Update the users password
            $password = $this->User->generatePassword();
            $this->User->id = $data['User']['id'];
            $this->User->saveField('password', $this->Auth->password($password));
            $this->set('success', true);

            // Send email with new password
            $this->Email->to = $data['User']['email'];
            $this->Email->subject = 'Password Changed';
            $this->Email->from = 'Support <support@example.com>';
            $this->Email->template = 'verify';
            $this->set('user', $data);
            $this->set('password', $password);
            $this->Email->send();
        }
        else{
        	$this->Session->setFlash('Not a valid token');
        	$this->redirect(array('controller' => 'users', 'action' => 'account'));
        }
    }

    /**
     * Displays list of users for edting - Admin access only
     */
     function admin_index() { 
		if (isset($_SESSION['User']['foundset'])) {
		  $this->redirect(array('action'=>'admin_querylist'));
        }
        if ($this->Auth->user('role') == '[Full Access]') {
			$this->layout = "index";
			$this->User->recursive = -1; 
			$this->set('users', $this->paginate()); 
		} else {
		$this->Session->setFlash('Your user account role (' . $this->Auth->user('role') . ') does not have access to this feature (' . $this->action .').','flash_error');
 		$this->redirect('/default');
		}
        $current_user = $this->User->findById($this->Auth->user('id'));
        $this->set('current_user', $current_user);
	} 
    /**
     * Edit user record - Admin access only
     */	
	function admin_edit($id = null) { 
        if ($this->Auth->user('role') == '[Full Access]') {
        
			if (!$id && empty($this->data)){ 
				$this->Session->setFlash('Invalid Record','flash_error'); 
				$this->redirect(array('url' => '/users/admin_index')); 
			} 
			if (!empty($this->data)){ 
			//          Save Edited Changes
			if(isset($this->params['form']['user_inactive_checkbox']) && count($this->params['form']['user_inactive_checkbox'])) {
				$this->data['User']['inactive'] = implode("\r",$this->params['form']['user_inactive_checkbox']);
			} else {
				$this->data['User']['inactive'] = 0;
			}
				if ($this->User->save($this->data,$validate=false)) { 
					$this->Session->setFlash('The User record has been saved', 'flash_info'); 
					if (isset($_SESSION['User']['foundset'])) {
						$this->redirect(array('action'=>'admin_querylist'));
					} else {
						$this->redirect(array('action'=>'admin_index'));
					}	

				} else { 
					$this->Session->setFlash('The Record could not be saved. Please try again.'.'<br/>'.implode('<br/>',$this->User->validationErrors),'flash_error'); 
				} 
			} 
			if (empty($this->data)){ 
				$this->data=$this->User->read(null, $id); 
			} 

			// put the current record id into session variable
			$_SESSION['User']['current_record'] = $id;
			$this->set("user_inactive_checkbox",$this->prepareInputGroup("checkbox","user_inactive_checkbox",array("1"=>""),$this->data['User']['inactive']));

		} else {
		// invalid role
		$this->Session->setFlash('Your user account role (' . $this->Auth->user('role') . ') does not have access to this feature (' . $this->action .').','flash_error');
		$this->redirect('/default');
		}
	}
    /**
     * Query user records - Admin access only
     */		
		function admin_query($id = null) {
	        if ($this->Auth->user('role') == '[Full Access]') {
        		// Clear SESSION when performing a new search
				unset($_SESSION['User']['foundset']);
				if (!empty($this->data)) {
					$conditions = array();
					foreach($this->data['User'] as $key=>$val) {
						if (!empty($val)) {
						// Exact query
						// $conditions['User.'.$key] = $val;
						// Fuzzy query
						$conditions['User.'.$key.' LIKE'] = '%'.$val.'%';
					}
				}
				if (!empty($conditions)) {
					$results = $this->User->find('all', array(
						'conditions'=>$conditions,
						'order'=>array('User.id ASC'),
					));
				if (!empty($results)) {
					foreach($results as $result) {
						// Save found record IDs into SESSION
						$_SESSION['User']['foundset'][] = $result['User']['id'];
						}
					$this->redirect(array('action'=>'admin_querylist'));
				} else {
					$this->Session->setFlash('0 Records Found.', 'flash_info'); 
				}
					} else {
						$this->Session->setFlash('Please enter at least one query condition.','flash_info'); 
					}
				} 
				$this->data = $this->User->find('first', array('conditions'=>array('User.id'=>$id),'recursive'=>-1));
			} else {
			// invalid role
			$this->Session->setFlash('Your user account role (' . $this->Auth->user('role') . ') does not have access to this feature (' . $this->action .').','flash_error');
			$this->redirect('/default');
			}
		} 
    /**
     * Clear Foundset of user records - Admin access only
     */		
    function clearfoundset() {
        unset($_SESSION['User']['foundset']);
        $this->redirect(array('action'=>'admin_index'));
    }
    /**
     * Displays Foundset list of users for edting - Admin access only
     */
		function admin_querylist() {
        if ($this->Auth->user('role') == '[Full Access]') {
        	if (isset($_SESSION['User']['foundset'])) {
				$current_user = $this->User->findById($this->Auth->user('id'));
        		$this->set('current_user', $current_user);
        		$this->paginate = array(
						'User'=>array(
							'conditions'=>array(
							'User.id'=>$_SESSION['User']['foundset']
						),
						'order'=>array(
							'User.id ASC'
						),
						'limit'=>10
				));
				$results = $this->paginate('User');
				$this->set('users', $results);
			} else {
				$this->redirect(array('action'=>'admin_query'));
			}
		} else {
		$this->Session->setFlash('Your user account role (' . $this->Auth->user('role') . ') does not have access to this feature' . $this->action .'.','flash_error');
 		$this->redirect('/default');
		}		
	}
    /**
     * Delete Selected Record in List - Admin access only
     */	
	function admin_delete($id = null) { 
        if ($this->Auth->user('role') == '[Full Access]') {
        	switch (true) {
        		case (!$id):
        			$this->Session->setFlash('Invalid id for Record','flash_error'); 
					$this->redirect(array('action'=>'admin_index')); 
        			break;
        		case ($this->Auth->user('id') == $id):
        			// do not delete current logged in user account
        			$this->Session->setFlash('You can not delete your current login account.','flash_error');
        			$this->redirect(array('action'=>'admin_index'));
        			break;
        		case ($this->User->delete($id)):
					$this->Session->setFlash('Record deleted', 'flash_info'); 
					$this->redirect(array('action'=>'admin_index'));         	
        			break;
     	   }
		} else {
			$this->Session->setFlash('Your user account role (' . $this->Auth->user('role') . ') does not have access to this feature (' . $this->action .').','flash_error');
 			$this->redirect('/default');
		}			
	}
    /**
     * View user record - Admin access only
     */	
	function admin_view($id = null) { 
        if ($this->Auth->user('role') == '[Full Access]') {
        
			if (!$id && empty($this->data)){ 
				$this->Session->setFlash('Invalid Record','flash_error'); 
				$this->redirect(array('url' => '/users/admin_index')); 
			} 
			
			if (empty($this->data)){ 
				$this->data=$this->User->read(null, $id); 
			} 

			// put the current record id into session variable
			$_SESSION['User']['current_record'] = $id;
			$this->set("user_inactive_checkbox",$this->prepareInputGroup("checkbox","user_inactive_checkbox",array("1"=>""),$this->data['User']['inactive']));

		} else {
		// invalid role
		$this->Session->setFlash('Your user account role (' . $this->Auth->user('role') . ') does not have access to this feature (' . $this->action .').','flash_error');
		$this->redirect('/default');
		}
	}
}
