<?php
class TblAsset extends AppModel {
    var $name = 'TblAsset';
    var $actsAs = array('Containable');
    var $useTable = 'tbl_assets';
    var $primaryKey = 'id';
    var $hasMany = array(
        'TblMaintenanceRecord'=>array(
        'className'=>'TblMaintenanceRecord',
        'foreignKey'=>'asset_id',
        'conditions'=>null,
        'dependent'=>true,
        'fields'=>null,
        ));


		var $validate = array(
			'validation_test_4_digit_year' => array(
							'rule' => array('date','mdy'),
							'message' => 'The year must have the format: MMDDYYYY'
							),
			'validation_test_time' => array(
							'rule' => 'time',
							'message' => 'The Time must be in the format HH:MM:SS'
							),
			'validation_test_not_empty' => array(
							'rule' => 'notEmpty',
							'message' => 'This field must not be empty.'
							),
			'validation_test_unique' => array(
							'rule' => 'isUnique',
							'message' => 'The field validation test_Unique must be a Unique value.'
							),
			'validation_test_by_value_list' => array(
							'rule'=>'validation_test_by_value_list_InValidationList',
							'message' => 'The field validation test_By Value List must have a value within the Condition List Value List.'
							),
			'validation_test_value_range' => array(
							'rule' => array('range', 1 , 10 ),
							'message' => 'The field validation test_Value_Range must be within the range 1 - 10'
							),
			'validation_test_max_chars5' => array(
							'rule' => array('maxLength',5),
							'message' => 'The field validation test_Max Chars5 must contain a maximum of 5 characters.'
							),
//			'validation_test_calculation_formula' => array(
//							'rule' => 'ID = 1', // Table: tbl_assets
//							'message' => 'The field validation test_Calculation_Formula is validated by a Calculation Formula.'
//							),
			'validation_test_strict_numeric' => array(
							'rule' => 'numeric',
							'message' => 'The value must be Numeric Only'
							),
			'validation_test_4_digit_year_and_unique' => array(
							'rule' => array('date','mdy'),
							'isUnique' => array(true)
							),
			'validation_test_max_chars5_and_value_range' => array(
							'rule' => array('maxLength',5),
							array('range',1 , 10 ),
							'message' => 'Range 1 - 10 and Maximum 5 chars Validation'
							),
			'validation_test_time_and_not_empty' => array(
							'rule' => 'time',
							'notEmpty' => array(true),
							'message' => 'Time format & Not Empty Validation Test'
							),
		); // end of validate array definition

	function validation_test_by_value_list_InValidationList($check) {
		// Parameters: 
		// $check - field data being validated 
		App::import('Controller', "App");
		$AppController = new AppController;
		$condition_list = $AppController->define_condition_list_value_list();
		$validation_test_by_value_list = array();
		foreach ($condition_list as $val) {
			$validation_test_by_value_list[] = $val;
		}  	
		$fname = ''; 
		foreach ($check as $key => $value){ 
	    $fname = $key; 
	    break; 
		} 
		return in_array($check[$fname], $validation_test_by_value_list);
	}


} 
?>
