using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace Assets002ns
{
    public abstract class WindowBase : Window, INotifyPropertyChanged 
    {

        protected internal abstract double CurrentRecordPosition
        {
            get;
            set;
        }

        protected internal abstract int TotalRecords
        {
            get;
        }

        public void HandleToolbarButton_Click(object sender, RoutedEventArgs e)
        {
            string buttonName = (sender as Button).Name;
            switch (buttonName)
            {
                case "btnPreviousRecord":
                    this.MoveToPreviousRecord();
                    this.ReBind();
                    break;
                case "btnNextRecord":
                    this.MoveToNextRecord();
                    this.ReBind();
                    break;
                case "btnDeleteRecord":
                    this.DeleteCurrentRecord();
                    this.ReBind();
                    break;
                case "btnNewRecord":
                    this.NewRecord();
                    this.ReBind();
                    break;
                case "btnSaveRecord":
                    this.SaveRecords();
                    this.ReBind();
                    break;
            }
            }

        protected internal abstract void SaveRecords();
        protected internal abstract void NewRecord();
        protected internal abstract void DeleteCurrentRecord();
        protected internal abstract void MoveToNextRecord();
        protected internal abstract void MoveToPreviousRecord();
        protected internal abstract void ReBind();

        public event PropertyChangedEventHandler PropertyChanged;

        protected internal void NotifyPropertyChanged(String info)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(info));
            }
        }

    }
}
