

Imports System.Windows.Media
Imports System.Windows.Media.Imaging
Imports System.Windows.Navigation
Imports System.Windows.Shapes
Imports System.IO
Imports System.ComponentModel
Imports System.Windows.Markup
Imports System.Xml
Imports AssetsDBModel

Namespace Assets002ns
    ' <summary>
    ' Interaction logic for Maintenance_recordWindow.xaml
    ' </summary>
    Class Maintenance_recordWindow
        Inherits WindowBase
        Private assetsdbEntities As AssetsDBModel.AssetsDBEntities = Nothing
        Private maintenance_recordViewSource As System.Windows.Data.CollectionViewSource = Nothing
        Private maintenance_recordQuery As System.Data.Objects.ObjectQuery(Of maintenance_record) = Nothing
        Private asset_management2ViewSource As System.Windows.Data.CollectionViewSource = Nothing
        Private asset_management2Query As System.Data.Objects.ObjectQuery(Of asset_management2) = Nothing

        Private Function Getmaintenance_recordQuery(ByVal assetsdbEntities As AssetsDBModel.AssetsDBEntities) As System.Data.Objects.ObjectQuery(Of maintenance_record)
            ' Auto generated code
            Dim maintenance_recordQuery As System.Data.Objects.ObjectQuery(Of maintenance_record) = assetsdbEntities.maintenance_record
            'Update the query to include related table data in "asset_management2. You can modify this code as needed.
            maintenance_recordQuery = maintenance_recordQuery.Include("asset_management2")
            ' Returns an ObjectQuery.
            Return maintenance_recordQuery
        End Function

        Private Function Getasset_management2Query(ByVal assetsdbEntities As AssetsDBModel.AssetsDBEntities) As System.Data.Objects.ObjectQuery(Of asset_management2)
            ' Auto generated code
            Dim asset_management2Query As System.Data.Objects.ObjectQuery(Of asset_management2) = assetsdbEntities.asset_management2
            'Update the query to include related table data in "asset_management2". You can modify this code as needed.
            asset_management2Query = asset_management2Query.Include("maintenance_record")
            ' Returns an ObjectQuery.
            Return asset_management2Query
        End Function

        Private Sub Window_Loaded(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs) Handles MyBase.Loaded
            assetsdbEntities = New AssetsDBModel.AssetsDBEntities()
            ' Load data into maintenance_record. You can modify this code as needed.
            maintenance_recordViewSource = DirectCast(Me.FindResource("maintenance_recordViewSource"), System.Windows.Data.CollectionViewSource)
            maintenance_recordQuery = Me.Getmaintenance_recordQuery(assetsdbEntities)
            maintenance_recordViewSource.Source = maintenance_recordQuery
            asset_management2ViewSource = DirectCast(Me.FindResource("asset_management2ViewSource"), System.Windows.Data.CollectionViewSource)
            asset_management2Query = Me.Getasset_management2Query(assetsdbEntities)
            asset_management2ViewSource.Source = asset_management2Query
            Me.ReBind()
        End Sub

        Public Sub New()
            ' This call is required by the designer.
            InitializeComponent()

            ' Add any initialization after the InitializeComponent() call.
        End Sub

        Protected Friend Sub Show_Toolbar()
            If Me.toolBarUserControl1.IsVisible Then
                Me.toolBarUserControl1.Visibility = Windows.Visibility.Hidden
            Else
                Me.toolBarUserControl1.Visibility = Windows.Visibility.Visible
            End If
        End Sub

        Protected Friend Overrides ReadOnly Property TotalRecords() As Integer
            Get
                Dim currentTable = assetsdbEntities.maintenance_record.AsQueryable()
                Dim maxRecords As Integer = currentTable.Count()
                Return maxRecords
            End Get
        End Property

        Protected Friend Overrides Property CurrentRecordPosition() As Double
            Get
                If maintenance_recordViewSource IsNot Nothing Then
                    Return CDbl(maintenance_recordViewSource.View.CurrentPosition)
                Else
                    Return 0.0

                End If
            End Get

            Set(ByVal value As Double)
                Dim newPosition As Integer = CInt(Math.Truncate(value))
                Dim currentTable = assetsdbEntities.maintenance_record.AsQueryable()
                Dim maxRecords As Integer = currentTable.Count() - 1

                If newPosition > maxRecords Then
                    newPosition = maxRecords
                End If

                maintenance_recordViewSource.View.MoveCurrentToPosition(newPosition)
                NotifyPropertyChanged("CurrentRecordPosition")
            End Set
        End Property

        Protected Friend Overrides Sub SaveRecords()
            Try
                Me.assetsdbEntities.SaveChanges()
            Catch generatedExceptionName As Exception
                'Error handling                
                Throw
            End Try
        End Sub

        Protected Friend Overrides Sub NewRecord()
            Try
                Dim entity = assetsdbEntities.CreateObject(Of maintenance_record)()
                assetsdbEntities.AddTomaintenance_record(entity)
            Catch generatedExceptionName As Exception
                'Error Handling
                Throw
            End Try

            Me.SaveRecords()
            maintenance_recordViewSource.Source = maintenance_recordQuery
            maintenance_recordViewSource.View.MoveCurrentToLast()

            NotifyPropertyChanged("TotalRecords")
        End Sub

        Protected Friend Overrides Sub DeleteCurrentRecord()
            Try
                Dim entity = maintenance_recordViewSource.View.CurrentItem
                assetsdbEntities.DeleteObject(entity)
            Catch generatedExceptionName As Exception
                'Error Handling        
                Throw
            End Try
            Me.SaveRecords()
            maintenance_recordViewSource.View.Refresh()
            NotifyPropertyChanged("TotalRecords")
        End Sub

        Protected Friend Overrides Sub MoveToNextRecord()
            If maintenance_recordViewSource.View.CurrentPosition < DirectCast(maintenance_recordViewSource.View, CollectionView).Count - 1 Then
                maintenance_recordViewSource.View.MoveCurrentToNext()
            End If
            Me.SaveRecords()
            NotifyPropertyChanged("CurrentRecordPosition")
        End Sub

        Protected Friend Overrides Sub MoveToPreviousRecord()
            If maintenance_recordViewSource.View.CurrentPosition > 0 Then
                maintenance_recordViewSource.View.MoveCurrentToPrevious()
            End If
            Me.SaveRecords()
            NotifyPropertyChanged("CurrentRecordPosition")
        End Sub

        Protected Friend Overrides Sub ReBind()
        End Sub


    End Class
End Namespace
